<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prediksi Rating Film - Collaborative Filtering</title>
    <style>
        /* Gaya dasar untuk body */
        body {
            font-family: 'Inter', sans-serif; /* Menggunakan font Inter */
            margin: 0;
            padding: 20px;
            background-color: #f0f2f5; /* Warna latar belakang lembut */
            color: #333;
            line-height: 1.6;
        }

        /* Container utama untuk konten aplikasi */
        .container {
            max-width: 900px;
            margin: 30px auto;
            background: #ffffff;
            padding: 30px;
            border-radius: 12px; /* Sudut membulat */
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1); /* Bayangan lebih halus */
            border: 1px solid #e0e0e0;
        }

        /* Judul H1, H2, H3 */
        h1, h2, h3 {
            color: #2c3e50; /* Warna biru gelap untuk judul */
            text-align: center;
            margin-bottom: 25px;
            font-weight: 600;
        }
        h1 {
            font-size: 2.5em;
            color: #007bff; /* Warna biru primer */
        }
        h2 {
            font-size: 1.8em;
            border-bottom: 2px solid #f0f0f0;
            padding-bottom: 10px;
            margin-top: 40px;
        }
        h3 {
            font-size: 1.4em;
            color: #28a745; /* Warna hijau untuk hasil prediksi */
        }

        /* Bagian identitas mahasiswa */
        .header-info {
            display: flex;
            align-items: center;
            justify-content: center; /* Pusatkan konten */
            margin-bottom: 40px;
            padding-bottom: 20px;
            border-bottom: 1px solid #e9ecef;
            text-align: left; /* Sesuaikan teks di dalam */
            flex-wrap: wrap; /* Izinkan wrapping untuk responsif */
        }
        .header-info img {
            border-radius: 50%; /* Foto bulat */
            width: 120px;
            height: 120px;
            object-fit: cover;
            margin-right: 25px;
            border: 4px solid #007bff; /* Bingkai biru */
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
        }
        .header-text {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }
        .header-text p {
            margin: 0;
            font-size: 1.1em;
            color: #555;
        }
        .header-text p strong {
            color: #333;
        }

        /* Tabel data */
        table {
            width: 100%;
            border-collapse: separate; /* Untuk border-radius pada sel */
            border-spacing: 0;
            margin-bottom: 30px;
            overflow: hidden; /* Penting untuk border-radius */
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
            border-radius: 8px; /* Sudut membulat pada tabel */
        }
        th, td {
            padding: 12px 15px;
            text-align: center;
            border-bottom: 1px solid #dee2e6; /* Garis bawah sel */
            border-right: 1px solid #dee2e6; /* Garis kanan sel */
        }
        th:last-child, td:last-child {
            border-right: none; /* Hilangkan garis kanan pada kolom terakhir */
        }
        tr:last-child td {
            border-bottom: none; /* Hilangkan garis bawah pada baris terakhir */
        }
        th {
            background-color: #007bff; /* Header biru */
            color: white;
            font-weight: 600;
            text-transform: uppercase;
        }
        tr:nth-child(even) {
            background-color: #f8f9fa; /* Warna selang-seling */
        }
        tr:hover {
            background-color: #e2f0fb; /* Efek hover pada baris */
            cursor: default;
        }

        /* Bagian hasil prediksi */
        .prediction-result {
            margin-top: 40px;
            padding: 30px;
            background-color: #e6ffed; /* Latar belakang hijau muda */
            border: 1px solid #a8e6b9;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 4px 15px rgba(40, 167, 69, 0.1); /* Bayangan hijau */
        }
        .prediction-result h3 {
            font-size: 2em;
            margin-top: 15px;
            margin-bottom: 15px;
            color: #28a745; /* Warna hijau kuat */
        }
        .prediction-result p {
            font-size: 1.1em;
            color: #444;
        }

        /* Informasi tambahan / catatan */
        .info {
            margin-top: 40px;
            padding: 20px;
            background-color: #f8f9fa; /* Latar belakang abu-abu muda */
            border-left: 5px solid #007bff; /* Garis biru di kiri */
            border-radius: 8px;
            font-size: 0.95em;
            color: #666;
            line-height: 1.8;
        }
        .info h3 {
            color: #007bff;
            text-align: left;
            margin-bottom: 15px;
        }
        .info ol {
            padding-left: 25px;
        }
        .info li {
            margin-bottom: 10px;
        }
        .info strong {
            color: #333;
        }
        .info ul {
            list-style-type: disc;
            padding-left: 20px;
            margin-top: 5px;
        }

        /* Gaya untuk pesan error */
        .error {
            color: #dc3545; /* Merah untuk error */
            font-weight: bold;
            text-align: center;
            padding: 15px;
            background-color: #ffebe9;
            border: 1px solid #dc3545;
            border-radius: 8px;
            margin-bottom: 20px;
        }

        /* Responsifitas */
        @media (max-width: 768px) {
            .header-info {
                flex-direction: column;
                text-align: center;
            }
            .header-info img {
                margin-right: 0;
                margin-bottom: 20px;
            }
            table, thead, tbody, th, td, tr {
                display: block; /* Tampilan tumpuk untuk tabel */
            }
            thead tr {
                position: absolute;
                top: -9999px;
                left: -9999px;
            }
            tr {
                border: 1px solid #dee2e6;
                margin-bottom: 15px;
                border-radius: 8px;
                overflow: hidden;
            }
            td {
                border: none;
                border-bottom: 1px solid #dee2e6;
                position: relative;
                padding-left: 50%;
                text-align: right;
            }
            td:before {
                position: absolute;
                top: 0;
                left: 6px;
                width: 45%;
                padding-right: 10px;
                white-space: nowrap;
                text-align: left;
                font-weight: bold;
                color: #007bff;
            }
            /* Label untuk setiap kolom pada tampilan mobile */
            td:nth-of-type(1):before { content: "User"; }
            td:nth-of-type(2):before { content: "Interstellar"; }
            td:nth-of-type(3):before { content: "Inception"; }
            td:nth-of-type(4):before { content: "Titanic"; }
            td:nth-of-type(5):before { content: "Avatar"; }
            td:nth-of-type(6):before { content: "Matrix"; }
        }
    </style>
    <!-- Link ke Google Fonts untuk Inter -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="container">
        <!-- Bagian a. Identitas Mahasiswa -->
        <div class="header-info">
            <?php
            // Ganti 'images/your_photo.jpg' dengan path relatif ke foto Anda
            // Pastikan Anda membuat folder 'images' di direktori yang sama dengan file index.php
            // Dan letakkan foto Anda di sana (misalnya: your_photo.jpg)
            $foto_mahasiswa = 'images/logo.png'; // Contoh: 'images/22001000_nama_anda.jpg'
            if (file_exists($foto_mahasiswa)) {
                echo '<img src="' . htmlspecialchars($foto_mahasiswa) . '" alt="Foto Mahasiswa">';
            } else {
                // Placeholder jika foto tidak ditemukan, dari placehold.co
                echo '<img src="https://placehold.co/120x120/a9d5ed/007bff?text=FOTO" alt="Foto Tidak Ditemukan">';
            }
            ?>
            <div class="header-text">
                <h1>Aplikasi Prediksi Rating Film</h1>
                <p><strong>NIM:</strong> 2302050824</p>
                <p><strong>Nama:</strong> Mokhammad Ali Aziz</p>
                <p><strong>Prodi/Semester:</strong> Sistem Informasi/Semester 4</p>
                <p><strong>Kelas:</strong> B</p>
            </div>
        </div>

        <?php
        // Konfigurasi koneksi database
        $servername = "localhost"; // Biasanya 'localhost'
        $username = "root";      // Username MySQL Anda
        $password = "";          // Password MySQL Anda (kosong jika tidak ada)
        $dbname = "sr"; // Nama database yang sudah Anda buat

        // Membuat koneksi ke database
        $conn = new mysqli($servername, $username, $password, $dbname);

        // Memeriksa koneksi
        if ($conn->connect_error) {
            die("<div class='error'>Koneksi database gagal: " . $conn->connect_error . "</div>");
        }

        /**
         * Fungsi untuk menghitung Cosine Similarity antara dua set rating.
         * Cosine similarity mengukur sudut antara dua vektor rating.
         *
         * @param array $ratings1 Array rating pengguna 1 [film => rating]
         * @param array $ratings2 Array rating pengguna 2 [film => rating]
         * @return float Nilai cosine similarity, berkisar antara 0 dan 1.
         */
        function cosine_similarity($ratings1, $ratings2) {
            $dot_product = 0;
            $magnitude1 = 0;
            $magnitude2 = 0;
            $common_items = 0;

            // Iterasi melalui semua film
            foreach ($ratings1 as $movie => $rating1) {
                if (isset($ratings2[$movie])) {
                    $rating2 = $ratings2[$movie];
                    // Hanya hitung jika kedua rating bukan 0
                    if ($rating1 > 0 && $rating2 > 0) {
                        $dot_product += ($rating1 * $rating2);
                        $magnitude1 += ($rating1 * $rating1);
                        $magnitude2 += ($rating2 * $rating2);
                        $common_items++;
                    }
                }
            }

            // Jika tidak ada item yang dirating bersama
            if ($common_items == 0 || $magnitude1 == 0 || $magnitude2 == 0) {
                return 0;
            }

            $magnitude1 = sqrt($magnitude1);
            $magnitude2 = sqrt($magnitude2);

            return $dot_product / ($magnitude1 * $magnitude2);
        }

        /**
         * Fungsi untuk menghitung Pearson Correlation Coefficient antara dua set rating.
         * Hanya menghitung untuk item (film) yang dirating oleh kedua pengguna.
         *
         * @param array $ratings1 Array rating pengguna 1 [film => rating]
         * @param array $ratings2 Array rating pengguna 2 [film => rating]
         * @return float Nilai korelasi Pearson, berkisar antara -1 dan 1. Mengembalikan 0 jika tidak ada item yang sama atau pembagian dengan nol.
         */
        function pearson_correlation($ratings1, $ratings2) {
            $sum_xy = 0;
            $sum_x = 0;
            $sum_y = 0;
            $sum_x2 = 0;
            $sum_y2 = 0;
            $n = 0; // Jumlah item yang dirating bersama

            // Iterasi melalui rating pengguna pertama
            foreach ($ratings1 as $movie => $rating1) {
                // Pastikan film juga dirating oleh pengguna kedua dan ratingnya bukan 0 (tidak ada rating)
                if (isset($ratings2[$movie]) && $rating1 !== 0 && $ratings2[$movie] !== 0) {
                    $rating2 = $ratings2[$movie];
                    $sum_xy += ($rating1 * $rating2);
                    $sum_x += $rating1;
                    $sum_y += $rating2;
                    $sum_x2 += ($rating1 * $rating1);
                    $sum_y2 += ($rating2 * $rating2);
                    $n++;
                }
            }

            // Jika tidak ada item yang dirating bersama, atau data tidak cukup
            if ($n == 0 || ($n * $sum_x2 - ($sum_x * $sum_x)) == 0 || ($n * $sum_y2 - ($sum_y * $sum_y)) == 0) {
                return 0;
            }

            // Menghitung Pearson correlation
            $numerator = $n * $sum_xy - ($sum_x * $sum_y);
            $denominator = sqrt(($n * $sum_x2 - ($sum_x * $sum_x)) * ($n * $sum_y2 - ($sum_y * $sum_y)));

            if ($denominator == 0) {
                return 0; // Hindari pembagian dengan nol
            }

            return $numerator / $denominator;
        }

        /**
         * Fungsi untuk memprediksi rating menggunakan user-based collaborative filtering.
         * Mencari user yang mirip dengan user target dan menghitung rata-rata tertimbang
         * dari rating mereka untuk film target menggunakan Cosine Similarity.
         *
         * @param string $user_id_target ID pengguna yang akan diprediksi (misal: 'U2')
         * @param string $movie_target Nama film yang akan diprediksi (misal: 'Matrix')
         * @param array $all_ratings Array asosiatif dari semua rating [user_id][movie_name] = rating
         * @return float|null Rating yang diprediksi atau null jika tidak bisa diprediksi.
         */
        function predict_rating($user_id_target, $movie_target, $all_ratings) {
            // Rating dari pengguna target
            $target_user_ratings = $all_ratings[$user_id_target] ?? [];

            $sum_weighted_ratings = 0;
            $sum_similarity = 0;
            $similar_users_found = 0;

            // Iterasi melalui semua pengguna lain
            foreach ($all_ratings as $user_id_other => $other_ratings) {
                // Lewati pengguna target itu sendiri
                if ($user_id_other == $user_id_target) {
                    continue;
                }

                // Periksa apakah pengguna lain sudah memberi rating pada film target dan ratingnya bukan 0
                if (!isset($other_ratings[$movie_target]) || $other_ratings[$movie_target] == 0) {
                    continue; // Lewati jika pengguna lain belum memberi rating atau ratingnya 0 (tidak ada rating yang berarti)
                }

                // Hitung similaritas menggunakan Cosine Similarity
                $similarity = cosine_similarity($target_user_ratings, $other_ratings);
                
                // Gunakan threshold untuk cosine similarity
                if ($similarity > 0.1) {
                    $sum_weighted_ratings += ($similarity * $other_ratings[$movie_target]);
                    $sum_similarity += $similarity;
                    $similar_users_found++;
                }
            }

            // Jika tidak ada user yang bisa digunakan untuk prediksi
            if ($sum_similarity == 0) {
                // Fallback: gunakan rata-rata rating dari semua user untuk film target
                $total_rating = 0;
                $rating_count = 0;
                foreach ($all_ratings as $user_id_other => $other_ratings) {
                    if ($user_id_other != $user_id_target && isset($other_ratings[$movie_target]) && $other_ratings[$movie_target] > 0) {
                        $total_rating += $other_ratings[$movie_target];
                        $rating_count++;
                    }
                }
                
                if ($rating_count > 0) {
                    return $total_rating / $rating_count; // Rata-rata rating global
                }
                
                return null;
            }

            // Hitung prediksi rating
            return $sum_weighted_ratings / $sum_similarity;
        }

        // --- Ambil semua data rating dari database ---
        $sql = "SELECT user_id, Interstellar, Inception, Titanic, Avatar, Matrix FROM movie_ratings ORDER BY CAST(SUBSTRING(user_id, 2) AS UNSIGNED)";
        $result = $conn->query($sql);

        $all_data_raw = []; // Untuk menampilkan semua data mentah dalam tabel
        $all_ratings_processed = []; // Untuk digunakan dalam perhitungan CF (User-Based)

        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $all_data_raw[] = $row; // Simpan baris mentah
                $user_id = $row['user_id'];
                // Simpan rating dalam format yang mudah diolah untuk fungsi prediksi
                $all_ratings_processed[$user_id] = [
                    'Interstellar' => (int)$row['Interstellar'],
                    'Inception'    => (int)$row['Inception'],
                    'Titanic'      => (int)$row['Titanic'],
                    'Avatar'       => (int)$row['Avatar'],
                    'Matrix'       => (int)$row['Matrix']
                ];
            }
        } else {
            echo "<p class='info'>Tidak ada data rating ditemukan di database.</p>";
        }

        // Tutup koneksi database setelah selesai mengambil data
        $conn->close();
        ?>

        <!-- Bagian b. Seluruh data ditampilkan -->
        <h2>Data Rating Film</h2>
        <?php if (!empty($all_data_raw)): ?>
        <table>
            <thead>
                <tr>
                    <th>User</th>
                    <th>Interstellar</th>
                    <th>Inception</th>
                    <th>Titanic</th>
                    <th>Avatar</th>
                    <th>Matrix</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($all_data_raw as $row): ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['user_id']); ?></td>
                    <td><?php echo htmlspecialchars($row['Interstellar']); ?></td>
                    <td><?php echo htmlspecialchars($row['Inception']); ?></td>
                    <td><?php echo htmlspecialchars($row['Titanic']); ?></td>
                    <td><?php echo htmlspecialchars($row['Avatar']); ?></td>
                    <td><?php echo htmlspecialchars($row['Matrix']); ?></td>

                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
            <p class='info'>Silakan pastikan tabel 'movie_ratings' di database 'movie_prediction_db' sudah terisi data.</p>
        <?php endif; ?>

        <!-- Bagian c. Hasil prediksi rating -->
        <div class="prediction-result">
            <h2>Hasil Prediksi Rating</h2>
            
            <!-- Form untuk memilih user dan film -->
            <form method="GET" action="" style="margin-bottom: 30px; padding: 20px; background-color: #f8f9fa; border-radius: 8px;">
                <div style="display: flex; gap: 20px; align-items: center; justify-content: center; flex-wrap: wrap;">
                    <div>
                        <label for="target_user" style="display: block; margin-bottom: 5px; font-weight: 600;">Pilih User:</label>
                        <select name="target_user" id="target_user" style="padding: 8px 12px; border: 1px solid #ddd; border-radius: 4px; min-width: 100px;">
                            <?php
                            // Ambil semua user_id yang tersedia
                            $available_users = array_keys($all_ratings_processed);
                            sort($available_users, SORT_NATURAL); // Sort secara natural (U1, U2, U10, dll)
                            
                            foreach ($available_users as $user) {
                                $selected = (isset($_GET['target_user']) && $_GET['target_user'] == $user) ? 'selected' : '';
                                echo "<option value='$user' $selected>$user</option>";
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div>
                        <label for="target_movie" style="display: block; margin-bottom: 5px; font-weight: 600;">Pilih Film:</label>
                        <select name="target_movie" id="target_movie" style="padding: 8px 12px; border: 1px solid #ddd; border-radius: 4px; min-width: 120px;">
                            <?php
                            $movies = ['Interstellar', 'Inception', 'Titanic', 'Avatar', 'Matrix'];
                            foreach ($movies as $movie) {
                                $selected = (isset($_GET['target_movie']) && $_GET['target_movie'] == $movie) ? 'selected' : '';
                                echo "<option value='$movie' $selected>$movie</option>";
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div style="align-self: end;">
                        <button type="submit" style="padding: 8px 16px; background-color: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer;">Prediksi Rating</button>
                    </div>
                </div>
            </form>
            
            <?php
            // Ambil parameter dari form atau gunakan default
            $target_user = $_GET['target_user'] ?? 'U2';
            $target_movie = $_GET['target_movie'] ?? 'Matrix';

            // Memastikan data untuk pengguna target ada
            if (isset($all_ratings_processed[$target_user])) {
                $current_rating = $all_ratings_processed[$target_user][$target_movie] ?? 0;
                $predicted_rating = predict_rating($target_user, $target_movie, $all_ratings_processed);

                echo "<p>Analisis untuk <strong>" . htmlspecialchars($target_user) . "</strong> terhadap film <strong>" . htmlspecialchars($target_movie) . "</strong>:</p>";
                
                // Tampilkan rating saat ini
                if ($current_rating > 0) {
                    echo "<p><strong>Rating saat ini:</strong> " . $current_rating . "</p>";
                } else {
                    echo "<p><strong>Rating saat ini:</strong> Belum dirating (0)</p>";
                }
                
                // Tampilkan prediksi
                if ($predicted_rating !== null) {
                    echo "<h3>Prediksi Rating: " . round($predicted_rating, 2) . "</h3>";
                    echo "<p>Prediksi ini menggunakan Metode <strong>Collaborative Filtering (User-Based)</strong> dengan <strong>Cosine Similarity</strong>.</p>";
                    
                    // Tampilkan informasi detail untuk debugging
                    echo "<div style='margin-top: 20px; padding: 15px; background-color: #f0f8ff; border-radius: 8px;'>";
                    echo "<h4>Detail Perhitungan:</h4>";
                    
                    // Hitung dan tampilkan detail perhitungan
                    $target_user_ratings = $all_ratings_processed[$target_user];
                    $sum_weighted_ratings = 0;
                    $sum_similarity = 0;
                    $contributing_users = [];
                    
                    foreach ($all_ratings_processed as $user_id_other => $other_ratings) {
                        if ($user_id_other == $target_user) continue;
                        if (!isset($other_ratings[$target_movie]) || $other_ratings[$target_movie] == 0) continue;
                        
                        $similarity = cosine_similarity($target_user_ratings, $other_ratings);
                        if ($similarity > 0.1) {
                            $weighted_rating = $similarity * $other_ratings[$target_movie];
                            $sum_weighted_ratings += $weighted_rating;
                            $sum_similarity += $similarity;
                            
                            $contributing_users[] = [
                                'user' => $user_id_other,
                                'rating' => $other_ratings[$target_movie],
                                'similarity' => $similarity,
                                'weighted_rating' => $weighted_rating
                            ];
                        }
                    }
                    
                    echo "<p><strong>Jumlah user yang berkontribusi:</strong> " . count($contributing_users) . "</p>";
                    
                    if (!empty($contributing_users)) {
                        echo "<p><strong>Detail kontribusi:</strong></p>";
                        echo "<ul>";
                        foreach ($contributing_users as $contrib) {
                            echo "<li><strong>" . $contrib['user'] . "</strong>: Rating=" . $contrib['rating'] . 
                                 ", Similarity=" . round($contrib['similarity'], 3) . 
                                 ", Weighted=" . round($contrib['weighted_rating'], 3) . "</li>";
                        }
                        echo "</ul>";
                        
                        echo "<p><strong>Total weighted ratings:</strong> " . round($sum_weighted_ratings, 3) . "</p>";
                        echo "<p><strong>Total similarity:</strong> " . round($sum_similarity, 3) . "</p>";
                        echo "<p><strong>Prediksi = " . round($sum_weighted_ratings, 3) . " / " . round($sum_similarity, 3) . " = " . round($predicted_rating, 3) . "</strong></p>";
                    } else {
                        echo "<p><strong>Menggunakan rata-rata global:</strong></p>";
                        $global_ratings = [];
                        foreach ($all_ratings_processed as $user_id_other => $other_ratings) {
                            if ($user_id_other != $target_user && isset($other_ratings[$target_movie]) && $other_ratings[$target_movie] > 0) {
                                $global_ratings[] = $other_ratings[$target_movie];
                            }
                        }
                        echo "<p>Rating dari user lain: " . implode(", ", $global_ratings) . "</p>";
                        echo "<p>Rata-rata = " . round(array_sum($global_ratings) / count($global_ratings), 3) . "</p>";
                    }
                    
                    echo "</div>";
                    
                } else {
                    echo "<p class='info'>Tidak dapat memprediksi rating untuk <strong>" . htmlspecialchars($target_user) . "</strong> terhadap <strong>" . htmlspecialchars($target_movie) . "</strong>. </p>";
                    echo "<p class='info'>Hal ini mungkin terjadi karena:</p>";
                    echo "<ul>";
                    echo "<li>Tidak ada pengguna lain yang cukup mirip dengan " . htmlspecialchars($target_user) . ".</li>";
                    echo "<li>Tidak ada pengguna lain yang mirip yang telah memberi rating pada film " . htmlspecialchars($target_movie) . ".</li>";
                    echo "<li>User " . htmlspecialchars($target_user) . " belum memberikan rating yang cukup untuk film lain.</li>";
                    echo "</ul>";
                    
                    // Debugging detail untuk kasus gagal
                    echo "<div style='margin-top: 20px; padding: 15px; background-color: #fff3cd; border-radius: 8px;'>";
                    echo "<h4>Analisis Detail:</h4>";
                    
                    // Tampilkan rating user target
                    echo "<p><strong>Rating User " . htmlspecialchars($target_user) . ":</strong></p>";
                    echo "<ul>";
                    foreach ($all_ratings_processed[$target_user] as $movie => $rating) {
                        echo "<li><strong>$movie:</strong> $rating</li>";
                    }
                    echo "</ul>";
                    
                    // Cek user lain yang sudah rating film target
                    echo "<p><strong>User lain yang sudah rating " . htmlspecialchars($target_movie) . ":</strong></p>";
                    $users_with_rating = [];
                    $similarity_analysis = [];
                    
                    foreach ($all_ratings_processed as $user_id => $ratings) {
                        if ($user_id != $target_user && isset($ratings[$target_movie]) && $ratings[$target_movie] > 0) {
                            $users_with_rating[] = "$user_id: " . $ratings[$target_movie];
                            
                            // Hitung similarity dengan user target
                            $similarity = cosine_similarity($all_ratings_processed[$target_user], $ratings);
                            $similarity_analysis[] = "$user_id: similarity=" . round($similarity, 3) . " (threshold: 0.1)";
                        }
                    }
                    
                    if (!empty($users_with_rating)) {
                        echo "<p>Rating: " . implode(", ", $users_with_rating) . "</p>";
                        echo "<p>Similarity analysis: " . implode(", ", $similarity_analysis) . "</p>";
                    } else {
                        echo "<p>Tidak ada user lain yang sudah rating film ini.</p>";
                    }
                    
                    echo "</div>";
                }
            } else {
                echo "<p class='error'>User <strong>" . htmlspecialchars($target_user) . "</strong> tidak ditemukan dalam data rating. Harap periksa `user_id` di database.</p>";
            }
            ?>
        </div>
    </div>
</body>
</html>
